/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf;

import io.gitlab.jfronny.commons.Serializer;
import io.gitlab.jfronny.commons.logger.DelegateLogger;
import io.gitlab.jfronny.commons.logger.HotswapLoggerFinder;
import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.commons.serialize.databind.DatabindSerializer;
import io.gitlab.jfronny.commons.serialize.databind.ObjectMapper;
import io.gitlab.jfronny.commons.serialize.json.JsonReader;
import io.gitlab.jfronny.commons.serialize.json.JsonTransport;
import io.gitlab.jfronny.commons.serialize.json.JsonWriter;
import io.gitlab.jfronny.libjf.log.JULBridge;
import io.gitlab.jfronny.libjf.log.SLF4JPlatformLogger;
import io.gitlab.jfronny.libjf.serialize.LenientTransport;
import java.io.IOException;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import org.slf4j.LoggerFactory;

public class LibJf
implements PreLaunchEntrypoint {
    public static final String MOD_ID = "libjf";
    public static final SystemLoggerPlus LOGGER = SystemLoggerPlus.forName("libjf");
    public static final ObjectMapper MAPPER = new ObjectMapper();
    public static final JsonTransport JSON_TRANSPORT = new JsonTransport();
    public static final JsonTransport LENIENT_TRANSPORT = new LenientTransport();
    private static boolean setup;
    private static boolean bootstrapped;

    public void onPreLaunch() {
        LibJf.setup();
    }

    public static void setup() {
        LibJf.bootstrap();
        if (!setup) {
            setup = true;
            HotswapLoggerFinder.updateAllStrategies((name, module, level) -> new SLF4JPlatformLogger(LoggerFactory.getLogger((String)name)));
        }
    }

    public static void bootstrap() {
        if (!bootstrapped) {
            bootstrapped = true;
            if (LOGGER instanceof DelegateLogger) {
                LOGGER.debug("HotswapLoggerFinder was loaded successfully. No need to install JULBridge.", new Object[0]);
            } else {
                JULBridge.install();
                LOGGER.debug("JULBridge was installed. If available in your launcher, please enable the ServiceLoader fix for better performance.", new Object[0]);
            }
        }
    }

    static {
        Serializer.setInstance(new DatabindSerializer<IOException, JsonReader, JsonWriter>(JSON_TRANSPORT, MAPPER));
        setup = false;
        bootstrapped = false;
    }
}

